//
//	Define Validate class
//

function Validate() {}

Validate.prototype.isOnlyAlphaNumeric = function(string)
{
	var invalidCharactersRegExp = /[^a-z\d ^(󜟿)]/i;
	// uwaga, ten sposb walidacji polskich znakw nie dziaa w Mozilli/Netscape
	var isValid = !(invalidCharactersRegExp.test(string));
	
	return isValid;
}


Validate.prototype.isOnlyAlphabetic = function(string)
{
	invalidCharactersRegExp = /[^a-z^(󜳟) ]/i;
	// uwaga, ten sposb walidacji polskich znakw nie dziaa w Mozilli/Netscape
	var isValid = !(invalidCharactersRegExp.test(string));
	
	return isValid;
}


Validate.prototype.isValidPostalCode = function(postalCode)
{
	var validFormat = /^(\d{2}(-\d{3})?|[a-z][a-z]\d\d? ?\d[a-z][a-z])$/i
	var isValid = validFormat.test(postalCode);
	return isValid;
}

Validate.prototype.isValidEmail = function(email)
{
	var validFormatRegExp = /^\w(\.?\w)*@\w(\.?[-\w])*\.([a-z]{3}(\.[a-z]{2})?|[a-z]{2}(\.[a-z]{2})?)$/i
	var isValid = validFormatRegExp.test(email);
	return isValid;
}


Validate.prototype.isValidCreditCardExpiry = function(expiresMonth, expiresYear)
{
	var isValid = true;
	var nowDate = new Date();
	if (expiresMonth < (nowDate.getMonth() + 1) && expiresYear <= nowDate.getFullYear())
	{
		isValid = false;
	}
	else if (expiresYear < nowDate.getFullYear())
	{
		isValid = false;
	}
	
	
	return isValid;
}

Validate.prototype.isValidCreditCardNumber = function(cardNumber, cardType)
{
	var isValid = false;
	var ccCheckRegExp = /[^\d ]/;
	isValid = !ccCheckRegExp.test(cardNumber);

	if (isValid)
	{
		var cardNumbersOnly = cardNumber.replace(/ /g,"");
		var cardNumberLength = cardNumbersOnly.length;
		var lengthIsValid = false;
		var prefixIsValid = false;
		var prefixRegExp;
		
		switch(cardType)
		{
			case "mastercard":
				lengthIsValid = (cardNumberLength == 16);
				prefixRegExp = /^5[1-5]/;
				break;
			
			case "visa":
				lengthIsValid = (cardNumberLength == 16 || cardNumberLength == 13);
				prefixRegExp = /^4/;
				break;
				
			case "amex":
				lengthIsValid = (cardNumberLength == 15);
				prefixRegExp = /^3(4|7)/;
				break;
				
			default:
				prefixRegExp = /^$/;
				alert("Card type not found");
		}
		
		prefixIsValid = prefixRegExp.test(cardNumbersOnly);
		isValid = prefixIsValid && lengthIsValid;
	}
	
	if (isValid)
	{
		var numberProduct;
		var numberProductDigitIndex;
		var checkSumTotal = 0;

		for (digitCounter = cardNumberLength - 1; digitCounter > 0; digitCounter--)
		{
		
       	  checkSumTotal += parseInt(cardNumbersOnly.charAt(digitCounter));	
       	  digitCounter--;
       	  
       	  numberProduct = new String((cardNumbersOnly.charAt(digitCounter) * 2));
		  
		  for (	var productDigitCounter = 0; 
				productDigitCounter < numberProduct.length; 
				productDigitCounter++
		  	  )
		  {
			checkSumTotal += parseInt(numberProduct.charAt(productDigitCounter));
		  }
		  
	    }
		
	    isValid = (checkSumTotal % 10 == 0);
	
     }
			
	return isValid;
}





Validate.prototype.checkFormValid = function(theForm,theDocument)
{
	var isWholeFormValid = true;
	var isValid = true;
	var theElement;
	var isToBeValidatedElementRegExp = /(_Compulsory)|(_NotCompulsory)/i;
	var isCompulsoryRegExp = /(_Compulsory)/i;
	var validDataTypeRegExp = /_[a-zA-Z]+$/i;
	var invalidDataType;
	var elementName;
	var errorDivId;
	var isCompulsoryElement;
	var isToBeCheckedElement;
	var isTextBoxElement;
	
// Check Text boxes completed and/or correct data type	
	for (var elementCounter = 0; elementCounter < theForm.length; elementCounter++)
	{
		theElement = theForm.elements[elementCounter];
		elementName = new String(theElement.name);

		isCompulsoryElement = isCompulsoryRegExp.test(elementName);
		
		isToBeValidatedElement = isToBeValidatedElementRegExp.test(elementName);
		
		if (isToBeValidatedElement)
		{
			errorDivId = new String(theElement.name);
			errorDivId = errorDivId.slice(3,errorDivId.indexOf("_")) + "Error";
			this.hideErrorDiv(errorDivId,theDocument);
					
			isTextBoxElement =  theElement.type == "text" || 
								theElement.type == "password" || 
								theElement.type == "file";
			
			if ( isTextBoxElement )
			{
				isValid = this.isTextElementValid(theElement,
												  theDocument,
												  validDataTypeRegExp,
												  isCompulsoryElement);
				
				if ( !isValid )
				{
					this.showErrorDiv(errorDivId,theDocument);
					theElement.focus();
					isWholeFormValid = false;
				}
			} //Check Compulsory Radio Buttons Completed
			else if (theElement.type == "radio")
			{

				if (isCompulsoryElement)
				{
					elementName = theElement.name;
					theElement = theForm.elements[theElement.name];
					isValid = this.isOneRadioButtonInGroupSelected(theElement);

					if (isValid == false)
					{
						this.showErrorDiv(errorDivId,theDocument);		
						isWholeFormValid = false;			
					}

					do 
					{
						elementCounter++;
						theElement = theForm.elements[elementCounter];
					}
					while (theElement.name == elementName && elementCounter < theForm.length)
						
					elementCounter--;
				}
			}
		}
	}

	return isWholeFormValid;
}

Validate.prototype.isTextElementValid = function(theElement,
												theDocument,
												validDataTypeRegExp, 
												isCompulsoryElement)
{

	var isValid = true;
	var validDataType;
	
	if (isCompulsoryElement && theElement.value == "")
	{
		isValid = false;	
	}
	else
	{				
		validDataTypeRegExp.exec(theElement.name);
		validDataType = new String(RegExp.lastMatch)
		validDataType = validDataType.toLowerCase();
		isValid = this.isElementDataValid(theElement.value,validDataType)
	}	
	
	return isValid;
}

Validate.prototype.isElementDataValid = function(elementValue, validDataType)
{
	var isValid = false;
	switch (validDataType)
	{

		case "_alphanumeric":
			isValid = this.isOnlyAlphaNumeric(elementValue);
			break;
	
		case "_alphabetic":
			isValid = this.isOnlyAlphabetic(elementValue);
			break;

		case "_postcode":	
			isValid = this.isValidPostalCode(elementValue);
			break;
	
		case "_email":
			isValid = this.isValidEmail(elementValue);
			break;
			
		default:
			alert("Error unidentified element data type");
	}
			
	return isValid;
}



Validate.prototype.isOneRadioButtonInGroupSelected = function(theElement)
{

	var radioCounter;
	var isValid = false;
	for (radioCounter = theElement.length - 1; radioCounter >= 0; radioCounter--)
	{

		isValid = theElement[radioCounter].checked;
		if (isValid)
		{
			break;
		}
	}

	return isValid;

}


Validate.prototype.showErrorDiv = function (  errorDescripDivId, 
								theDocument)
{
  if (document.layers)
  {
 	theDocument.layers[errorDescripDivId].visibility = "visible";
  }
  else if (document.all)
  {
	theDocument.all(errorDescripDivId).style.visibility = "visible"
  }
  else
  {
    theDocument.getElementById(errorDescripDivId).style.visibility = "visible"
  }
}


Validate.prototype.hideErrorDiv = function (errorDescripDivId, theDocument)
{
  if (theDocument.layers)
  {
	theDocument.layers[errorDescripDivId].visibility = "hidden";
  }
  else if (document.all)
  {
	theDocument.all(errorDescripDivId).style.visibility = "hidden"
  }
  else
  {
 	theDocument.getElementById(errorDescripDivId).style.visibility = "hidden"	
  }
}
